IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_MOVIMENTO_ANTERIOR]'))
	DROP VIEW [dbo].[V_EST_PROD_MOVIMENTO_ANTERIOR]
GO
GO
CREATE VIEW [dbo].[V_EST_PROD_MOVIMENTO_ANTERIOR]
AS
SELECT     
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP, 
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_FILIAL, 
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS.DT_EMI_NF, 
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD, 
	dbo.EST_PROD.DS_PROD, 
	dbo.EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
    dbo.V_EST_NF_SAI_TRANSF_SAIDAS.VLR_IT,
	0 AS TIPO_DOCUMENTO,
	'TRANSFERENCIA SAIDA' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS INNER JOIN dbo.EST_PROD ON 
	dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = dbo.EST_PROD.CD_EMP AND 
    dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD = dbo.EST_PROD.CD_PROD
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC 	
WHERE NOT EXISTS (SELECT     
					CD_EMP
                  FROM          
					dbo.PRC_FILIAL
                  WHERE      
					dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = CD_EMP AND 
					dbo.V_EST_NF_SAI_TRANSF_SAIDAS.CD_FILIAL_DEST = CD_FILIAL AND 
					FILIAL_MTZ = 1)
UNION ALL
SELECT     
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP, 
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_FILIAL_DEST, 
	V_EST_NF_SAI_TRANSF_SAIDAS.DT_EMI_NF, 
    V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD, 
	EST_PROD.DS_PROD, 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
	V_EST_NF_SAI_TRANSF_SAIDAS.VLR_IT,
	1 AS TIPO_DOCUMENTO,
	'TRANSFERENCIA ENTRADA' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	V_EST_NF_SAI_TRANSF_SAIDAS 	INNER JOIN dbo.EST_PROD ON 
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = EST_PROD.CD_EMP AND 
    V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD = EST_PROD.CD_PROD
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	V_EST_NF_SAI_TRANSF_SAIDAS.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC 		
WHERE     EXISTS (SELECT     
						CD_EMP
                  FROM          
						dbo.EST_NF_ENT_EST_NF_SAI_TRANSF
                  WHERE      
					V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = CD_EMP AND 
					V_EST_NF_SAI_TRANSF_SAIDAS.CD_FILIAL_DEST = CD_FIL_DEST
					AND V_EST_NF_SAI_TRANSF_SAIDAS.CD_NF = CD_NF_SAI) 
				AND NOT EXISTS
                          (SELECT     
								CD_EMP
                            FROM          
								PRC_FILIAL 
                            WHERE		
									V_EST_NF_SAI_TRANSF_SAIDAS.CD_EMP = CD_EMP AND 
									V_EST_NF_SAI_TRANSF_SAIDAS.CD_FILIAL = CD_FILIAL AND 
                                    FILIAL_MTZ = 1)
UNION ALL
SELECT     
	dbo.EST_NF_ENT.CD_EMP, 
	dbo.EST_NF_ENT.CD_FILIAL, 
	dbo.EST_NF_ENT.DT_ENT, 
	dbo.EST_NF_ENT_IT.CD_PROD, 
	EST_PROD.DS_PROD, 
    EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
	dbo.EST_NF_ENT_IT.VLR_IT,
	2 AS TIPO_DOCUMENTO,
	'ENTRADA DEVOLUCAO' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	dbo.EST_NF_ENT INNER JOIN dbo.EST_NF_ENT_IT ON 
	dbo.EST_NF_ENT.CD_EMP = dbo.EST_NF_ENT_IT.CD_EMP AND 
    dbo.EST_NF_ENT.CD_FILIAL = dbo.EST_NF_ENT_IT.CD_FILIAL AND 
	dbo.EST_NF_ENT.CD_NF = dbo.EST_NF_ENT_IT.CD_NF AND
	dbo.EST_NF_ENT.DT_ENT = dbo.EST_NF_ENT_IT.DT_ENT 
	INNER JOIN dbo.EST_PROD ON 
	dbo.EST_NF_ENT_IT.CD_EMP = EST_PROD.CD_EMP AND 
    dbo.EST_NF_ENT_IT.CD_PROD = EST_PROD.CD_PROD INNER JOIN
    dbo.GLB_MOV_OP ON 
	dbo.EST_NF_ENT.CD_NT_MOV = dbo.GLB_MOV_OP.CD_MOV_OP
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	EST_NF_ENT_IT.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	EST_NF_ENT_IT.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC	
WHERE     
	dbo.GLB_MOV_OP.TP_MOV IN (11, 31) 
	AND dbo.GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 
	AND dbo.EST_NF_ENT.STS_NF = 0
UNION ALL
SELECT     
	EST_PROD_REQ_TRANSF_LIB.CD_EMP, 
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL_DEST, 
	EST_PROD_REQ_TRANSF_LIB.DT_CAD, 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD, 
	EST_PROD.DS_PROD, 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
	EST_PROD_REQ_TRANSF_LIB_ITENS.VLR_CUSTO,
	3 AS TIPO_DOCUMENTO,
	'REQUISICAO TRANSFERENCIA' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	EST_PROD_REQ_TRANSF_LIB INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON 
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL AND 
    EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ 
	INNER JOIN EST_PROD ON 
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD.CD_EMP AND 
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD.CD_PROD
	LEFT OUTER JOIN EST_PROD_REQ_TRANSF_LIB_EST_PED_VD ON 
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_FILIAL AND 
    EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_REQ 
	LEFT OUTER JOIN EST_PROD_TRANSF_PED_VD ON 
	EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_EMP = EST_PROD_TRANSF_PED_VD.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_FILIAL = EST_PROD_TRANSF_PED_VD.CD_FILIAL AND 
    EST_PROD_REQ_TRANSF_LIB_EST_PED_VD.CD_PED = EST_PROD_TRANSF_PED_VD.CD_PED
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 	
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC
WHERE
	EST_PROD_TRANSF_PED_VD.CD_CTR IS NULL
UNION ALL
SELECT     
	EST_PROD_REQ_TRANSF_LIB.CD_EMP, 
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL, 
	EST_PROD_REQ_TRANSF_LIB.DT_CAD, 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD, 
	EST_PROD.DS_PROD,
	 EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
	EST_PROD_REQ_TRANSF_LIB_ITENS.VLR_CUSTO,
	3 AS TIPO_DOCUMENTO,
	'REQUISICAO TRANSFERENCIA' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	EST_PROD_REQ_TRANSF_LIB INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON 
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL AND 
    EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ 
	INNER JOIN EST_PROD ON 
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD.CD_PROD
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC	
UNION ALL
SELECT     
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP, 
	PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL, 
	PDV_VD_DEV_EST_PROD_IMP.DT_DEVO, 
    PDV_VD_DEV_EST_PROD_IMP.CD_PROD, 
	EST_PROD.DS_PROD, 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA,  
	PDV_VD_DEV_EST_PROD_IMP.VLR_IT,
	4 AS TIPO_DOCUMENTO,
	'DEVOLUCAO REQUISICAO' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	PDV_VD_DEV_EST_PROD_IMP INNER JOIN EST_PROD ON 
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD.CD_EMP AND 
	PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD.CD_PROD
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC	
UNION ALL
SELECT     
	PDV_VD_IT.CD_EMP, 
	PDV_VD_IT.CD_FILIAL, 
	PDV_VD.DT_VD, 
    PDV_VD_IT.CD_PROD, 
	EST_PROD.DS_PROD, 
	 EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA,
	PDV_VD_IT.VLR_IT,
	5 AS TIPO_DOCUMENTO,
	'VENDA CUPOM CANCELADA' AS DS_TIPO_DOCUMENTO,
	FAB.NM_FABRIC
FROM         
	PDV_VD_IT INNER JOIN EST_PROD ON 
	PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND 
	PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD
	INNER JOIN PDV_VD ON
	PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD.CD_VD AND
	PDV_VD_IT.DT_VD = PDV_VD.DT_VD
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	PDV_VD_IT.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	PDV_VD_IT.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC	
WHERE
	PDV_VD.ST_VD = 1

